<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSelectedQuantityEventListener.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Listeners;

use Gambio\Shop\Properties\Database\Services\Interfaces\PropertiesReaderServiceInterface;
use Gambio\Shop\Properties\Properties\Entities\Combination;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Services\PropertyQuantityReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSelectedQuantityEventInterface;
use Gambio\Shop\SellingUnit\Unit\Exceptions\InsufficientQuantityException;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Interfaces\IncludeReservedOnQuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;


class OnGetSelectedQuantityEventListener
{
    /**
     * @var PropertiesReaderServiceInterface
     */
    protected $service;
    /**
     * @var PropertyQuantityReadServiceInterface
     */
    protected $propertyQuantityReadService;

    /**
     * OnGetSelectedQuantityListener constructor.
     *
     * @param PropertiesReaderServiceInterface $service
     * @param PropertyQuantityReadServiceInterface $propertyQuantityReadService
     */
    public function __construct(
        PropertiesReaderServiceInterface $service,
        PropertyQuantityReadServiceInterface $propertyQuantityReadService
    ) {

        $this->service = $service;
        $this->propertyQuantityReadService = $propertyQuantityReadService;
    }


    /**
     * @param OnGetSelectedQuantityEventInterface $event
     *
     * @return OnGetSelectedQuantityEventInterface
     */
    public function __invoke(OnGetSelectedQuantityEventInterface $event): OnGetSelectedQuantityEventInterface
    {
        return $event;
    }

    /**
     * @param SellingUnitId $id
     * @param Combination $combination
     * @return float
     */
    protected function getReservedQuantity(SellingUnitId $id, Combination $combination): float
    {
        $cartId = $id->productId()->value() . 'x' . $combination->id()->value();
        $result = 0;
        if (isset($_SESSION['cart']) && is_object($_SESSION['cart'])) {

            $result = (float)$_SESSION['cart']->get_quantity($cartId);
        }
        return $result;
    }
}